#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

// LIST OF SYSTEM PARAMETERS

#define KAZ_DS_SP_J             128
#define KAZ_DS_SP_K             128

#define KAZ_DS_SP_G             "6007"
#define KAZ_DS_SP_G0            "23102151283542472555351033031857407110549489214984451103786304558150674606117088000"
#define KAZ_DS_SP_LG0         	274

#define KAZ_DS_SP_R             "6151"
#define KAZ_DS_SP_G1           	"399620650696124709852000"
#define KAZ_DS_SP_LG1         	79

#define KAZ_DS_SP_Q             "1115881660253397921934830780"

#define KAZ_DS_SP_q             "246208917987764371328101733"

// LIST OF PRECOMPUTED PARAMETERS
		
#define KAZ_DS_SP_PHIG1        	"60408037934094090240000"
#define KAZ_DS_SP_PHIPHIG1     	"11456568251237007360000"

#define KAZ_DS_SP_PHIQ          "142607087754413919436800000"

#define KAZ_DS_SP_qQ			"274740016173379194546381236446787565723556071979741740"
#define KAZ_DS_SP_PHIqQ			"35111136773400413456929878039434623864922544537600000"

#define KAZ_DS_SP_G1Q			"445929355170334839245311003147590823180218844560000"
#define KAZ_DS_SP_G1qQ			"109791784035469620464528703986642036404462199422783032019481545979393622480000"

#define KAZ_DS_SP_RAN			4

#define KAZ_DS_SKBYTES    		32
#define KAZ_DS_V1BYTES          10
#define KAZ_DS_V2BYTES          23
#define KAZ_DS_SBYTES           32

extern void KAZ_DS_CRT(int t, mpz_t *c, mpz_t *modular, mpz_t crt);

extern void KAZ_DS_KEYGEN(unsigned char *kaz_ds_verify_key,
                          unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_SIGNATURE(unsigned char *signature,
                             unsigned long long *signlen,
                             const unsigned char *m,
                             unsigned long long mlen,
                             const unsigned char *kaz_ds_sign_key);

extern int KAZ_DS_VERIFICATION(unsigned char *m,
                               unsigned long long *mlen,
                               const unsigned char *sm,
                               unsigned long long smlen,
                               const unsigned char *pk);

#endif // FILE_H_INCLUDED
